//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	using BuildingClassEnum = mbin_gc.GcBuildingClassification.BuildingClassEnum;
	using ScannableTypeEnum = mbin_gc.GcScannableComponentData.ScannableTypeEnum;
	using ScanIconTypeEnum  = mbin_gc.GcScannerIconTypes.ScanIconTypeEnum;
	
	//=========================================================================
	
	// Automatically flag nearby locations.
	public class Scan_Auto : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
		//	GcGameplayGlobals();                  // testing
			GcBuildingGlobals();		
		//	TkAttachmentData_Grave();             // traveller grave w/ glyph, Start|Portal sets all known
		//	TkAttachmentData_BaseSite();          // base computer, generally don't use for bases
		//	TkAttachmentData_MinorSettlements();  // minor settlement, can't find unique entity to attach to
			TkAttachmentData_Portal();            // Portal, since game only finds 1 per system
			TkAttachmentData_BlackBox();          // crashed ship
		}
	
		//...........................................................

		protected void GcGameplayGlobals()
		{
			var mbin = Mbin<mbin_gl.GcGameplayGlobals>(
				"GCGAMEPLAYGLOBALS.GLOBAL.MBIN"
			);
			
			mbin.MissionSurveyMaxGuidanceDistance = 100;
			
			// when use binoc scan finds stuff farther away.
			mbin.TerrainResourceScanRange = 10000;  // 1200
			
			// finds distress when use ship scan.
			// works but basically only finds 1 per planet
			// and disables ship scan of planets and stuff.
			mbin.UseDebugScan             = true;   // false
			mbin.DebugScanForceBuilding   = true;   // false
			mbin.DebugScanForceBuildingType.BuildingClass = BuildingClassEnum.DistressSignal;  // None
		}

		//...........................................................

		protected void GcBuildingGlobals()
		{
			var mbin = Mbin<mbin_gl.GcBuildingGlobals>(
				"GCBUILDINGGLOBALS.GLOBAL.MBIN"
			);
			mbin.UnknownBuildingRange = 10000;  //  600
			mbin.MaxIconRange         = 10000;  // 1200
			mbin.MinShipScanBuildings = 1;  // 0
			mbin.MaxShipScanBuildings = 3;  // 2
		}

		//...........................................................

		protected void TkAttachmentData_Grave()
		{
			var mbin = Mbin<mbin_tk.TkAttachmentData>(
				"MODELS/PLANETS/BIOMES/COMMON/BUILDINGS/GRAVEINCAVE/GRAVEINCAVE/ENTITIES/GRAVEINCAVE.ENTITY.MBIN"
			);
			// already has GcScannableComponentData section
			var data  = FindGcScannableComponentData(mbin);
			if( data != null ) data.AlwaysShowRange = 100000;
		}

		//...........................................................

		protected void TkAttachmentData_BaseSite()
		{
			var mbin = Mbin<mbin_tk.TkAttachmentData>(
				"MODELS/PLANETS/BIOMES/COMMON/BUILDINGS/PARTS/BUILDABLEPARTS/BASECOMPUTER/ENTITIES/BASECOMPUTER.ENTITY.MBIN"
			);
			var data = CreateGcScannableComponentData("SIGNAL_BASE", ScanIconTypeEnum.FreighterTerminal);
			mbin.Components.Add(data);
		}

		//...........................................................

		protected void TkAttachmentData_MinorSettlements()
		{		
			var mbin = Mbin<mbin_tk.TkAttachmentData>(
				// not specific to minor settlements, applies to all occupied buildings
				"MODELS/PLANETS/BIOMES/COMMON/BUILDINGS/SHOP/SHOPWARRIOR/ENTITIES/SCIENTIFICBUILDING.ENTITY.MBIN"
			);
			var data = CreateGcScannableComponentData("SIGNAL_SHOP", ScanIconTypeEnum.FreighterDoor);
			mbin.Components.Add(data);
		}

		//...........................................................

		protected void TkAttachmentData_Portal()
		{
			var mbin = Mbin<mbin_tk.TkAttachmentData>(
				"MODELS/PLANETS/BIOMES/COMMON/BUILDINGS/PORTAL/PORTAL/ENTITIES/PORTAL.ENTITY.MBIN"
			);
			var data = CreateGcScannableComponentData("SIGNAL_PORTAL", ScanIconTypeEnum.Artifact);
			mbin.Components.Add(data);
		}

		//...........................................................

		protected void TkAttachmentData_BlackBox()
		{
			var mbin = Mbin<mbin_tk.TkAttachmentData>(
				"MODELS/PLANETS/BIOMES/COMMON/BUILDINGS/DISTRESSSIGNAL/PARTS/BLACKBOX/ENTITIES/BLACKBOX.ENTITY.MBIN"
			);
			var data = CreateGcScannableComponentData("SIGNAL_DISTRESSSIGNAL", ScanIconTypeEnum.HazardPlant);
			mbin.Components.Add(data);
		}

		//...........................................................

		protected mbin_gc.GcScannableComponentData FindGcScannableComponentData(
			mbin_tk.TkAttachmentData MBIN
		){
			foreach( var data in MBIN.Components ) {
				var scannable  = data as mbin_gc.GcScannableComponentData;
				if( scannable != null ) return scannable;
			}
			return null;
		}

		//...........................................................

		protected mbin_gc.GcScannableComponentData CreateGcScannableComponentData(
			string           NAME,
			ScanIconTypeEnum ICON_TYPE
		){
			var data = new mbin_gc.GcScannableComponentData {
				CompassRangeMultiplier = 0.5f,
				ScanName          = NAME,
				ScanTime          = 30,
				ScanRange         = 0,
				AlwaysShowRange   = 100000,
				CanTagIcon        = true,
				ClearTagOnArrival = true,
				ScannableType     = ScannableTypeEnum.Marker,
			};
			data.Icon = new(){ ScanIconType = ICON_TYPE };
			return data;
		}
	}
}

//=============================================================================
