//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	using GalaxyStarTypeEnum = mbin_gc.GcGalaxyStarTypes.GalaxyStarTypeEnum;
	
	//=========================================================================
	
	public class Space : cmk.NMS.ModScript
	{
		// Make star colors in galaxy map more vibrant.
		// Make space darker.
		// Adjust trade routes color alpha.
		protected override void Execute()
		{
			GcGalaxyGlobals();
			GcAISpaceshipGlobals();
			SpaceSkyColours();
		}

		//...........................................................

		protected void GcGalaxyGlobals()
		{
			var mbin = Mbin<mbin_gl.GcGalaxyGlobals>(
				"GCGALAXYGLOBALS.GLOBAL.MBIN"
			);
			
			// make star colours more vibrant
			var colors = mbin.BaseStarDefaultColours.ColourByStarType;
			colors[(int)GalaxyStarTypeEnum.Yellow] = new(0.5f, 0.4215f, 0.0f, 1);
			colors[(int)GalaxyStarTypeEnum.Green]  = new(0.0f, 0.5f,    0.0f, 1);
			colors[(int)GalaxyStarTypeEnum.Blue]   = new(0.0f, 0.0f,    0.5f, 1);
			colors[(int)GalaxyStarTypeEnum.Red]    = new(0.5f, 0.0f,    0.0f, 1);
			
			// nerf overly bright nebulae ?
			var render = mbin.DefaultRenderSetup;
			render.NebulaeAlphaPow           = 0;  //  1.4
			render.NebulaeTraceValueMult     = 0;  //  0.998
			render.NebulaeTraceScale         = 0;  //  0.75
			render.NebulaeTraceDensity       = 0;  //  0.65
			render.NebulaeTraceDensityCutoff = 0;  // -0.06
		}

		//...........................................................

		protected void GcAISpaceshipGlobals()
		{
			var mbin = Mbin<mbin_gl.GcAISpaceshipGlobals>(
				"GCAISPACESHIPGLOBALS.GLOBAL.MBIN"
			);
			// make trade routes more visible.
			// intended for vanilla space (non-dark)
			// to make it easier to follow them down to planet.
			// may want to adjust if using SpaceSkyColours below.
			foreach( var color in mbin.TradeRouteColours ) {
				color.A = 0.25f;  // 0.1
			}
		}

		//...........................................................

		protected void SpaceSkyColours()
		{
			string [] paths = new [] {
				"METADATA/SIMULATION/SOLARSYSTEM/WEATHER/SKYSETTINGS/SPACESKYCOLOURS.MBIN",
				"METADATA/SIMULATION/SOLARSYSTEM/WEATHER/SKYSETTINGS/SPACERARESKYCOLOURS.MBIN"
			};		
			foreach( var path in paths ) {
				var mbin = Mbin<mbin_gc.GcSpaceSkyColourSettingList>(path);
				GcSpaceSkyColourSettingList(mbin);
			}
		}
		
		//...........................................................

		protected void GcSpaceSkyColourSettingList( mbin_gc.GcSpaceSkyColourSettingList MBIN )
		{
			// make space darker
			foreach( var colors in MBIN.Settings ) {
				var space = 0.1f;
				colors.TopColour.R *= space;
				colors.TopColour.G *= space;
				colors.TopColour.B *= space;
				colors.MidColour.R *= space;
				colors.MidColour.G *= space;
				colors.MidColour.B *= space;
				colors.BottomColour.R *= space;
				colors.BottomColour.G *= space;
				colors.BottomColour.B *= space;

				var planet = 0.8f;
				colors.TopColourPlanet.R *= planet;
				colors.TopColourPlanet.G *= planet;
				colors.TopColourPlanet.B *= planet;
				colors.MidColourPlanet.R *= planet;
				colors.MidColourPlanet.G *= planet;
				colors.MidColourPlanet.B *= planet;
				colors.BottomColourPlanet.R *= planet;
				colors.BottomColourPlanet.G *= planet;
				colors.BottomColourPlanet.B *= planet;
				
				var nebula = 0.1f;
				colors.NebulaColour1.R *= nebula;
				colors.NebulaColour1.G *= nebula;
				colors.NebulaColour1.B *= nebula;
				colors.NebulaColour2.R *= nebula;
				colors.NebulaColour2.G *= nebula;
				colors.NebulaColour2.B *= nebula;
				colors.NebulaColour3.R *= nebula;
				colors.NebulaColour3.G *= nebula;
				colors.NebulaColour3.B *= nebula;
			}
		}		
	}
}

//=============================================================================
