//=============================================================================

using System.Collections.Generic;

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Settings|inventory for starting Ship when starting a new game.
	public class Start_Ship : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcRealityManagerData();
			GcDefaultSaveData();
		}

		//...........................................................
		
		protected void GcRealityManagerData()
		{
			var mbin = Mbin<mbin_gc.GcRealityManagerData>(
				"METADATA/REALITY/DEFAULTREALITY.MBIN"
			);
			mbin.ShipTechOnlyStartingLayout.Slots = 24;
			mbin.ShipStartingLayout        .Slots = 32;
		}

		//...........................................................

		protected void GcDefaultSaveData()
		{
			var mbin = Mbin<mbin_gc.GcDefaultSaveData>(
				"METADATA/GAMESTATE/DEFAULTSAVEDATA.MBIN"
			);
			GcInventoryContainer_Main(mbin.State.ShipInventory);
			List_KnownTech(mbin.State.KnownTech);
		}
	
		//...........................................................

		protected void GcInventoryContainer_Main( mbin_gc.GcInventoryContainer CONTAINER )
		{			
			CONTAINER.Slots.Clear();
			CONTAINER.AddTechnologyUnindexed("LAUNCHER",        100, 100);  // Launch Thruster
			CONTAINER.AddTechnologyUnindexed("UT_LAUNCHCHARGE", 100, 100);  // Launch System Recharger		
			CONTAINER.AddTechnologyUnindexed("SHIPMINIGUN",     100, 100);  // Infra-Knife Accelerator
			CONTAINER.AddTechnologyUnindexed("SHIPSHIELD",      100, 100);  // Deflector Shield
			CONTAINER.AddTechnologyUnindexed("UT_SHIPSHIELD",   100, 100);  // Ablative Armour
			CONTAINER.AddTechnologyUnindexed("SHIPJUMP1",       100, 100);  // Pulse Engine
			CONTAINER.AddTechnologyUnindexed("HYPERDRIVE",      100, 100);  // Hyperdrive
			CONTAINER.AddTechnologyUnindexed("UT_QUICKWARP" ,   100, 100);  // Emergency Warp Unit
			CONTAINER.AddTechnologyUnindexed("SHIP_TELEPORT",   100, 100);  // Teleport Receiver
			CONTAINER.AddTechnologyUnindexed("SHIPSCAN_ECON",   100, 100);  // Economy  Scanner
			CONTAINER.AddTechnologyUnindexed("SHIPSCAN_COMBAT", 100, 100);  // Conflict Scanner
		}

		//...........................................................

		protected void List_KnownTech( List<nms.NMSString0x10> LIST )
		{
			LIST.AddUnique("LAUNCHER");
			LIST.AddUnique("UT_LAUNCHCHARGE");
			LIST.AddUnique("SHIPMINIGUN");
			LIST.AddUnique("SHIPSHIELD");
			LIST.AddUnique("UT_SHIPSHIELD");
			LIST.AddUnique("SHIPJUMP1");
			LIST.AddUnique("HYPERDRIVE");
			LIST.AddUnique("UT_QUICKWARP");
			LIST.AddUnique("SHIP_TELEPORT");
			LIST.AddUnique("SHIPSCAN_ECON");
			LIST.AddUnique("SHIPSCAN_COMBAT");
		}
	}
}

//=============================================================================
