//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	using InventoryClassEnum       = mbin_gc.GcInventoryClass.InventoryClassEnum;
	using StatsTypeEnum            = mbin_gc.GcStatsTypes.StatsTypeEnum;
	using FrigateStatTypeEnum      = mbin_gc.GcFrigateStatType.FrigateStatTypeEnum;
	using FrigateTraitStrengthEnum = mbin_gc.GcFrigateTraitStrength.FrigateTraitStrengthEnum;
	
	//=========================================================================

	// Freq. of space battles that give freighter.
	// Multiply freighter jump distances by 10.
	// Reduce negative frigate traits.
	public class Freighter : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcDebugOptions();
			GcGameplayGlobals();
			GcPlayerGlobals();
			GcTechnologyTable();
			GcFleetGlobals();
		}

		//...........................................................

		protected void GcDebugOptions()
		{
			var mbin = Mbin<mbin_gl.GcDebugOptions>(
				"GCDEBUGOPTIONS.GLOBAL.MBIN"
			);
			mbin.MultiplePlayerFreightersInASystem = true;
		}

		//...........................................................

		protected void GcGameplayGlobals()
		{
			var mbin = Mbin<mbin_gl.GcGameplayGlobals>(
				"GCGAMEPLAYGLOBALS.GLOBAL.MBIN"
			);

			mbin.WarpsBetweenBattles = 5;  // 5
			mbin.HoursBetweenBattles = 1;  // 3
			
			// use Average from Class_Probabilities
			// note: 5 entries, not sure what last is for, always = 0
			mbin.FreighterTechQualityWeightings[(int)InventoryClassEnum.C] = 35;  // 55
			mbin.FreighterTechQualityWeightings[(int)InventoryClassEnum.B] = 35;  // 25
			mbin.FreighterTechQualityWeightings[(int)InventoryClassEnum.A] = 20;  // 15
			mbin.FreighterTechQualityWeightings[(int)InventoryClassEnum.S] = 10;  //  5
		}
		
		//...........................................................

		protected void GcPlayerGlobals()
		{
			var mbin = Mbin<mbin_gl.GcPlayerGlobals>(
				"GCPLAYERGLOBALS.GLOBAL.MBIN"
			);
			mbin.NumberOfWarpsRequiredForFreightersToSpawn = 5;  // 2
		}
		
		//...........................................................

		protected void GcTechnologyTable()
		{
			var mbin = Mbin<mbin_gc.GcTechnologyTable>(
				"METADATA/REALITY/TABLES/NMS_REALITY_GCTECHNOLOGYTABLE.MBIN"
			);
			// big ship should be able to do big jumps
			foreach( var tech in mbin.Table ) {
				var bonus  = tech.StatBonuses.Find(BONUS => BONUS.StatsTypes.StatsType == StatsTypeEnum.Freighter_Hyperdrive_JumpDistance);
				if( bonus != null ) bonus.Bonus *= 10;
			}
		}

		//...........................................................

		protected void GcFleetGlobals()
		{
			var mbin = Mbin<mbin_gl.GcFleetGlobals>(
				"GCFLEETGLOBALS.GLOBAL.MBIN"
			);
			
			mbin.PercentChangeOfFrigateBeingPurchasable = 70;  // 60
			mbin.NumberOfExpeditionChoices              =  8;  // 5
			mbin.TimeTakenForExpeditionEvent          = 1000;  // 5400
		//	mbin.ExpeditionsCompleteInstantly         = true;  // false
			mbin.LevelupProgressRequiredToNotBeSadAboutDamage = .80f;  // 0.95
			
			// reduce possible penalty values for frigates
			
			var stat = mbin.FrigateTraitStrengths.FrigateStatType[(int)FrigateStatTypeEnum.Combat].StatAlteration;
			stat[(int)FrigateTraitStrengthEnum.NegativeLarge]  = -2;  // -6
			stat[(int)FrigateTraitStrengthEnum.NegativeMedium] = -1;  // -4
			stat[(int)FrigateTraitStrengthEnum.NegativeSmall]  = -0;  // -2

			stat = mbin.FrigateTraitStrengths.FrigateStatType[(int)FrigateStatTypeEnum.Exploration].StatAlteration;
			stat[(int)FrigateTraitStrengthEnum.NegativeLarge]  = -3;  // -6
			stat[(int)FrigateTraitStrengthEnum.NegativeMedium] = -2;  // -4
			stat[(int)FrigateTraitStrengthEnum.NegativeSmall]  = -1;  // -2

			stat = mbin.FrigateTraitStrengths.FrigateStatType[(int)FrigateStatTypeEnum.Mining].StatAlteration;
			stat[(int)FrigateTraitStrengthEnum.NegativeLarge]  = -3;  // -6
			stat[(int)FrigateTraitStrengthEnum.NegativeMedium] = -2;  // -4
			stat[(int)FrigateTraitStrengthEnum.NegativeSmall]  = -1;  // -2

			stat = mbin.FrigateTraitStrengths.FrigateStatType[(int)FrigateStatTypeEnum.Diplomatic].StatAlteration;
			stat[(int)FrigateTraitStrengthEnum.NegativeLarge]  = -6;  // -6
			stat[(int)FrigateTraitStrengthEnum.NegativeMedium] = -4;  // -4
			stat[(int)FrigateTraitStrengthEnum.NegativeSmall]  = -2;  // -2

			stat = mbin.FrigateTraitStrengths.FrigateStatType[(int)FrigateStatTypeEnum.FuelBurnRate].StatAlteration;
			stat[(int)FrigateTraitStrengthEnum.NegativeLarge]  = 2;  // 4
			stat[(int)FrigateTraitStrengthEnum.NegativeMedium] = 1;  // 2
			stat[(int)FrigateTraitStrengthEnum.NegativeSmall]  = 0;  // 1
		}
	}
}

//=============================================================================
