//=============================================================================

using System.Collections.Generic;

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	using BuildingClassEnum = mbin_gc.GcBuildingClassification.BuildingClassEnum;

	//=========================================================================
	
	// Adjust startchart and random scan reward probabilities
	// i.e. what kind of location you find.
	// In particular it adds Base Sites and Portals as possible reward locations.
	// (base sites are flat round areas w/ existing base computer)
	public class Reward_Location : cmk.NMS.ModScript
	{	
		protected override void Execute()
		{
			GcBuildingDefinitionTable();
			GcRewardTable();
		}
		
		//...........................................................

		public static float SecureDepot     { get; set; } = 20;
		public static float SecureFactory   { get; set; } = 40;
		public static float SecureHarvester { get; set; } = 20;
		public static float SecureBaseSite  { get; set; } = 10;

		public static float DistressCrashedShip      { get; set; } = 65;
		public static float DistressCrashedShipNPC   { get; set; } =  0;
		public static float DistressCrashedFreighter { get; set; } = 25;

		public static float InhabitedLibrary     { get; set; } = 10;
		public static float InhabitedShelter     { get; set; } =  5;
		public static float InhabitedOutpost     { get; set; } = 10;
		public static float InhabitedShop        { get; set; } = 25;
		public static float InhabitedRadioTower  { get; set; } = 15;
		public static float InhabitedObservatory { get; set; } = 15;
		public static float InhabitedAbandoned   { get; set; } = 10;

		public static float AncientRuin     { get; set; } = 40;
		public static float AncientPlaque   { get; set; } = 20;
		public static float AncientMonolith { get; set; } = 20;
		public static float AncientPortal   { get; set; } = 10;

		//...........................................................

		protected void GcBuildingDefinitionTable()
		{
			var mbin = Mbin<mbin_gc.GcBuildingDefinitionTable>(
				"METADATA/SIMULATION/ENVIRONMENT/PLANETBUILDINGTABLE.MBIN"
			);
			var data = mbin.BuildingPlacement[(int)BuildingClassEnum.Base];
			data.AddWaypoint = true;
		}

		//...........................................................

		protected void GcRewardTable()
		{	
			var mbin = Mbin<mbin_gc.GcRewardTable>(
				"METADATA/REALITY/TABLES/REWARDTABLE.MBIN"
			);
			GcRewardTable_StarChart (mbin);
			GcRewardTable_RandomScan(mbin);
		}
		
		//...........................................................

		protected void GcRewardTable_StarChart( mbin_gc.GcRewardTable MBIN )
		{	
			var item = MBIN.SpecialRewardTable.Find(REWARD => REWARD.Id == "R_STARCHART_A");
			RewardA(item.List.List);

			item = MBIN.SpecialRewardTable.Find(REWARD => REWARD.Id == "R_STARCHART_B");
			RewardB(item.List.List);

			item = MBIN.SpecialRewardTable.Find(REWARD => REWARD.Id == "R_STARCHART_C");
			RewardC(item.List.List);

			item = MBIN.SpecialRewardTable.Find(REWARD => REWARD.Id == "R_STARCHART_D");
			RewardD(item.List.List);
		}		

		//...........................................................

		protected void GcRewardTable_RandomScan( mbin_gc.GcRewardTable MBIN )
		{	
			var item = MBIN.SpecialRewardTable.Find(REWARD => REWARD.Id == "RANDOM_SCAN_A");
			RewardA(item.List.List);

			item = MBIN.SpecialRewardTable.Find(REWARD => REWARD.Id == "RANDOM_SCAN_B");
			RewardB(item.List.List);

			item = MBIN.SpecialRewardTable.Find(REWARD => REWARD.Id == "RANDOM_SCAN_C");
			RewardC(item.List.List);

			item = MBIN.SpecialRewardTable.Find(REWARD => REWARD.Id == "RANDOM_SCAN_D");
			RewardD(item.List.List);
		}		

		//...........................................................

		// A : secure site
		// Old: Depot  6%, Factory 12%, Harvester  6%
		// New: Depot 20%, Factory 40%, Harvester 20%, Base 10%
		protected void RewardA( List<mbin_gc.GcRewardTableItem> LIST )
		{
			var reward = UpdateReward(LIST, "Depot",     SecureDepot);
			    reward = UpdateReward(LIST, "Factory",   SecureFactory);
			    reward = UpdateReward(LIST, "Harvester", SecureHarvester);
			    reward = CreateReward(LIST, SecureBaseSite,
					"Harvester", "HARVESTER",  // clone this
					"Base",      "BASE",       // to make this
					BuildingClassEnum.Base
				);
		}

		//...........................................................

		// B : distress signal
		// Old: Abandoned 12%, Distress  4%, Distress with NPC 4%, Crashed Freighter  4%, Observatory 6%
		// New:                Distress 60%, Distress with NPC 5%, Crashed Freighter 25%
		protected void RewardB( List<mbin_gc.GcRewardTableItem> LIST )
		{		
			var reward = UpdateReward(LIST, "Abandoned",         0);  // move to C
			    reward = UpdateReward(LIST, "Distress",          DistressCrashedShip);
			    reward = UpdateReward(LIST, "Distress with NPC", DistressCrashedShipNPC);
			    reward = UpdateReward(LIST, "Crashed Freighter", DistressCrashedFreighter);
			    reward = UpdateReward(LIST, "Observatory",       0);  // already in C
		}

		//...........................................................

		// C : inhabited outpost
		// Old: Library  5%, Shelter 8%, Outpost  5%, Shop 15%, RadioTower  8%, Observatory  8%
		// New: Library 10%, Shelter 5%, Outpost 10%, Shop 25%, RadioTower 15%, Observatory 15%, Abandoned 10%
		protected void RewardC( List<mbin_gc.GcRewardTableItem> LIST )
		{
			// error in game file, LabelID == "" for LIBRARY
			var reward  = LIST.Find(ITEM => ITEM.LabelID == "");
			if( reward != null ) reward.LabelID = "Library";

			reward = UpdateReward(LIST, "Library",     InhabitedLibrary);
			reward = UpdateReward(LIST, "Shelter",     InhabitedShelter);
			reward = UpdateReward(LIST, "Outpost",     InhabitedOutpost);
			reward = UpdateReward(LIST, "Shop",        InhabitedShop);
			reward = UpdateReward(LIST, "RadioTower",  InhabitedRadioTower);
			reward = UpdateReward(LIST, "Observatory", InhabitedObservatory);

			// yes, yes, not inhabited if abandoned,
			// but _was_ inhabited when chart created.
		    reward = CreateReward(LIST, InhabitedAbandoned,
				"Observatory", "OBSERVATORY",
				"Abandoned",   "ABANDONED",
				BuildingClassEnum.Abandoned
			);
		}

		//...........................................................

		// D : ancient artifact site
		// Old: Plaque 12%, Monolith 12%, Ruin 12%
		// Old: Plaque 20%, Monolith 20%, Ruin 40%, Potal 10%
		// Requires Portal to be added to SCANEVENTTABLEPLANET, see Scan_Auto.
		// Added Portal to compensate for game only allowing Monoliths to find 1 Portal in System instead of per Planet.
		protected void RewardD( List<mbin_gc.GcRewardTableItem> LIST )
		{
			var reward = UpdateReward(LIST, "Ruin",     AncientRuin);
			    reward = UpdateReward(LIST, "Plaque",   AncientPlaque);
			    reward = UpdateReward(LIST, "Monolith", AncientMonolith);
			    reward = CreateReward(LIST, AncientPortal,
					"Monolith", "MONOLITH",
					"Portal",   "PORTAL",
					BuildingClassEnum.Portal
				);
		}

		//...........................................................

		protected mbin_gc.GcRewardTableItem UpdateReward(
			List<mbin_gc.GcRewardTableItem> LIST, string ID, float PERCENT
		){
			var reward  = LIST.Find(ITEM => ITEM.LabelID == ID);
			if( reward != null ) {  // no error, not all R_STARCHART_* in RANDOM_SCAN_*
				if( PERCENT < 1 ) LIST.Remove(reward);
				else reward.PercentageChance = PERCENT;
			}
			return reward;
		}	
		
		//...........................................................

		protected mbin_gc.GcRewardTableItem CreateReward(
			List<mbin_gc.GcRewardTableItem> LIST,
			float  PERCENT,
			string SOURCE_ID,        // "Monolith", find in LIST
			string SOURCE_NAME,      // "MONOLITH", find in GcScanEventTable
			string TARGET_ID,        // "Portal",   add  to LIST
			string TARGET_NAME,      // "PORTAL",   add  to GcScanEventTable
			BuildingClassEnum CLASS  // BuildingClassEnum.Portal
		){
			if( PERCENT < 1 ) return null;
			
			GcScanEventTable_Add("SCANEVENTTABLEPLANET",  SOURCE_NAME, TARGET_NAME, CLASS);
			GcScanEventTable_Add("SCANEVENTTABLEVEHICLE", SOURCE_NAME, TARGET_NAME, CLASS);
	
			var target  = LIST.Find(ITEM => ITEM.LabelID == TARGET_ID);
			if( target == null ) {
				var source = LIST.Find(ITEM => ITEM.LabelID == SOURCE_ID);
				    target = source.Clone();
			
				 target.LabelID = TARGET_ID;
				(target.Reward as mbin_gc.GcRewardScanEvent).Event = TARGET_NAME;
			
				LIST.Add(target);
			}
			
			target.PercentageChance = PERCENT;
			return target;	
		}
		
		//...........................................................

		protected mbin_gc.GcScanEventData GcScanEventTable_Add(
			string TABLE,
			string SOURCE_NAME,      // "MONOLITH", find in TABLE.Events
			string TARGET_NAME,      // "PORTAL",   add  to TABLE.Events
			BuildingClassEnum CLASS  // BuildingClassEnum.Portal
		){
			var mbin = Mbin<mbin_gc.GcScanEventTable>(
				"METADATA/SIMULATION/SCANNING/" + TABLE + ".MBIN"
			);
			var target  = mbin.Events.Find(EVENT => EVENT.Name == TARGET_NAME);
			if( target != null ) return target;  // no error, already exists

			var source = mbin.Events.Find(EVENT => EVENT.Name == SOURCE_NAME);
			target = source.Clone();
			
			target.Name           = TARGET_NAME;
			target.OSDMessage     = "SIGNAL_" + TARGET_NAME;
			target.TooltipMessage = "TIP_"    + TARGET_NAME;
		//	target.SurveyDistance = 100000;
			target.BuildingClass.BuildingClass = CLASS;

			mbin.Events.Add(target);
			return target;
		}
	}
}

//=============================================================================
