//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Make ship salvage terminal on space station constructable anywhere.
	// If construct in a base then need to supply power.
	// If construct outside a base then don't need to supply power.
	// Clone DRESSING_TABLE i.e. character customimzer
	// since it's about the same size as the salvage station.
	// We will try to use the DRESSING_TABLE snap and lod files. 	
	public class Salvage : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcAISpaceshipGlobals();
			GcProductTable();
			GcBaseBuildingTable();		
			GcPurchaseableBuildingBlueprints();  // buy after start
			GcDefaultSaveData();                 // optional: known at start
		}

		//...........................................................

		protected void GcAISpaceshipGlobals()
		{
			var mbin = Mbin<mbin_gl.GcAISpaceshipGlobals>(
				"GCAISPACESHIPGLOBALS.GLOBAL.MBIN"
			);
			mbin.SalvageValueMultiplier                  = 0.8f;  // 0.6
			mbin.CrashedShipMinNonBrokenSlots            = 4;     // 3
			mbin.CrashedShipBrokenSlotChance             = 0.6f;  // 0.75
			mbin.CrashedShipBrokenTechChance             = 0.5f;  // 0.7
			mbin.CrashedShipRepairSlotCostIncreaseFactor = 1.2f;  // 1.3
			mbin.CrashedShipGeneralCostDiscount          = 0.8f;  // 0.7
			mbin.CrashedShipTechSlotsCostDiscount        = 0.2f;  // 0.1
			mbin.AbandonedSystemShipSpawnProbablity      = 2;     // 0
		}

		//...........................................................

		protected void GcProductTable()
		{
			var mbin = Mbin<mbin_gc.GcProductTable>(
				"METADATA/REALITY/TABLES/NMS_REALITY_GCPRODUCTTABLE.MBIN"
			);

			var dressing_table = mbin.Table.Find(OBJECT => OBJECT.Id == "DRESSING_TABLE");
			var salvage_term   = dressing_table.Clone();

			salvage_term.Id                = "SALVAGE_TERM";
			salvage_term.Name              = "SALVAGE";
			salvage_term.NameLower         = "Salvage";
			salvage_term.Subtitle.Value    = "Salvage";
			salvage_term.Description.Value = "UI_SALVAGE_DESC";
			salvage_term.Icon.Filename     = "TEXTURES/UI/FRONTEND/ICONS/BUILDABLE/RACESHIPSTART.DDS";

			mbin.Table.Add(salvage_term);
		}

		//...........................................................

		protected void GcBaseBuildingTable()
		{
			var mbin = Mbin<mbin_gc.GcBaseBuildingTable>(
				"METADATA/REALITY/TABLES/BASEBUILDINGTABLE.MBIN"
			);

			var dressing_table = mbin.Objects.Find(OBJECT => OBJECT.ID == "DRESSING_TABLE");
			var salvage_term   = dressing_table.Clone();

			salvage_term.ID                    = "SALVAGE_TERM";
			salvage_term.Model.Filename        = "MODELS/PLANETS/BIOMES/COMMON/BUILDINGS/PARTS/BUILDABLEPARTS/TECH/SHIPSALVAGETERMINAL.SCENE.MBIN";
			salvage_term.BaseTerrainEditShape  = mbin_gc.GcBaseBuildingEntry.BaseTerrainEditShapeEnum.Cylinder;
			salvage_term.IsFromModFolder       = true;
			salvage_term.PlanetBaseLimit       = 0;
			salvage_term.BuildableOnPlanetBase = true;
			salvage_term.BuildableOnSpaceBase  = true;
			salvage_term.BuildableOnFreighter  = true;
			salvage_term.BuildableOnPlanet     = true;
			salvage_term.EnableCollision       = true;  // required to interact
			salvage_term.CanPlaceOnItself      = true;
			salvage_term.CanRotate3D           = true;
			salvage_term.CanScale              = true;
			salvage_term.CanChangeColour       = true;
			salvage_term.CanChangeMaterial     = true;

			mbin.Objects.Add(salvage_term);
		}

		//...........................................................

		protected void GcPurchaseableBuildingBlueprints()
		{
			var mbin = Mbin<mbin_gc.GcPurchaseableBuildingBlueprints>(
				"METADATA/REALITY/TABLES/PURCHASEABLEBUILDINGBLUEPRINTS.MBIN"
			);
			mbin.Table.Add(new(){
				ProductID = "SALVAGE_TERM",
				GroupId   = 0,
			});
		}

		//...........................................................

		protected void GcDefaultSaveData()
		{
			string [] paths = new [] {
				"METADATA/GAMESTATE/DEFAULTSAVEDATA.MBIN",
				"METADATA/GAMESTATE/DEFAULTSAVEDATACREATIVE.MBIN"
			};		
			foreach( var path in paths ) {
				var mbin = Mbin<mbin_gc.GcDefaultSaveData>(path);
				mbin.State.KnownProducts.Add("SALVAGE_TERM");
			}
		}
	}
}

//=============================================================================
