//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	using AlienRaceEnum = mbin_gc.GcAlienRace.AlienRaceEnum;
	using ShipClassEnum = mbin_gc.GcSpaceshipClasses.ShipClassEnum;
	using StatsTypeEnum = mbin_gc.GcStatsTypes.StatsTypeEnum;

	//=========================================================================
	
	// Teleport range, auto-aim all weapons, hover, ...
	public class Ship : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcGameplayGlobals();
			GcTechnologyTable();
			GcAISpaceshipGlobals();
			GcRealityManagerData();
			GcSpaceshipGlobals();
			GcSolarGenerationGlobals();
		}
			
		//...........................................................

		protected void GcGameplayGlobals()
		{
			var mbin = Mbin<mbin_gl.GcGameplayGlobals>(
				"GCGAMEPLAYGLOBALS.GLOBAL.MBIN"
			);
			// interact with ship from farther away
			mbin.ShipInteractRadius = 2000;
		}

		//...........................................................

		protected void GcTechnologyTable()
		{
			var mbin = Mbin<mbin_gc.GcTechnologyTable>(
				"METADATA/REALITY/TABLES/NMS_REALITY_GCTECHNOLOGYTABLE.MBIN"
			);
			// teleport material between exosuit and ship from farther away
			var tech    = mbin.Table.Find(TECH => TECH.ID == "SHIP_TELEPORT");
			var bonus   = tech.StatBonuses.Find(BONUS => BONUS.StatsTypes.StatsType == StatsTypeEnum.Ship_Teleport);
			bonus.Bonus = 2000;
		}

		//...........................................................

		protected void GcAISpaceshipGlobals()
		{
			var mbin = Mbin<mbin_gl.GcAISpaceshipGlobals>(
				"GCAISPACESHIPGLOBALS.GLOBAL.MBIN"
			);
			mbin.VisibleDistance = 30000;  // 3500
		}

		//...........................................................

		protected void GcRealityManagerData()
		{
			var mbin = Mbin<mbin_gc.GcRealityManagerData>(
				"METADATA/REALITY/DEFAULTREALITY.MBIN"
			);
			// all ship weapons have auto-aim
			foreach( var weapon in mbin.ShipWeapons ) {
				weapon.AutoAimAngle      =  5;
				weapon.AutoAimExtraAngle = 15;
			}
		}

		//...........................................................

		protected void GcSpaceshipGlobals()
		{
			var mbin = Mbin<mbin_gl.GcSpaceshipGlobals>(
				"GCSPACESHIPGLOBALS.GLOBAL.MBIN"
			);

			mbin.GroundHeightSoft      =  7;  // 20
			mbin.GroundHeightSoftForce = 14;  // 35

			mbin.LandHeightThreshold     = 60;  // 100
			mbin.LandingPushNoseUpFactor =  0;  // 0.15

			// ship hover			
			var min_speed = 0.001f;

			mbin.HoverMinSpeed    = min_speed;  //  1
			mbin.HoverSpeedFactor = 0.001f;     // 20

			mbin.Control.SpaceEngine .MinSpeed = min_speed;
			mbin.Control.PlanetEngine.MinSpeed = min_speed;
			mbin.Control.CombatEngine.MinSpeed = min_speed;

			mbin.ControlLight.SpaceEngine .MinSpeed = min_speed;
			mbin.ControlLight.PlanetEngine.MinSpeed = min_speed;
			mbin.ControlLight.CombatEngine.MinSpeed = min_speed;

			mbin.ControlHeavy.SpaceEngine .MinSpeed = min_speed;
			mbin.ControlHeavy.PlanetEngine.MinSpeed = min_speed;
			mbin.ControlHeavy.CombatEngine.MinSpeed = min_speed;

			mbin.MiniWarpLinesNum             = 0;     // 4
			mbin.MiniWarpFlashIntensity       = 0.1f;  // 0.9
			mbin.MiniWarpHUDArrowAttractAngle = 2;     // 10

			mbin.FreighterBattleIgnoreFriendlyFireDistance = 1000000;  // 10,000
		}

		//...........................................................

		// adjust distribution of ship types in a system
		protected void GcSolarGenerationGlobals()
		{
			var mbin = Mbin<mbin_gl.GcSolarGenerationGlobals>(
				"GCSOLARGENERATIONGLOBALS.GLOBAL.MBIN"
			);
			
			// # of ship seeds generated per system - 1
		//	mbin.CivilianTraderSpaceshipsCacheCount = 40;  // 20, testing
			
			IncreaseChanceRoyal(mbin);
		//	ManyRoyal(mbin);  // testing
		}

		//...........................................................
		
		protected void IncreaseChanceRoyal( mbin_gl.GcSolarGenerationGlobals MBIN )
		{		
			// used to be array indexed on mbin_gc.GcAlienRace.AlienRaceEnum, now a List<>.
			// weightings is tied to enum, but enum is specified as an attrib.
			
			var weightings = MBIN.SpaceshipWeightings[(int)AlienRaceEnum.Traders].CivilianClassWeightings;
			weightings[(int)ShipClassEnum.Royal] = 11;

			weightings = MBIN.SpaceshipWeightings[(int)AlienRaceEnum.Warriors].CivilianClassWeightings;
			weightings[(int)ShipClassEnum.Royal] = 11;

			weightings = MBIN.SpaceshipWeightings[(int)AlienRaceEnum.Explorers].CivilianClassWeightings;
			weightings[(int)ShipClassEnum.Royal] = 11;
			
			// rest don't matter as they don't have their own systems

			weightings = MBIN.SpaceshipWeightings[(int)AlienRaceEnum.Robots].CivilianClassWeightings;
			weightings[(int)ShipClassEnum.Royal] = 11;

			weightings = MBIN.SpaceshipWeightings[(int)AlienRaceEnum.Atlas].CivilianClassWeightings;
			weightings[(int)ShipClassEnum.Royal] = 11;

			weightings = MBIN.SpaceshipWeightings[(int)AlienRaceEnum.Diplomats].CivilianClassWeightings;
			weightings[(int)ShipClassEnum.Royal] = 9;
			weightings[(int)ShipClassEnum.Alien] = 2;

			weightings = MBIN.SpaceshipWeightings[(int)AlienRaceEnum.Exotics].CivilianClassWeightings;
			weightings[(int)ShipClassEnum.Royal] = 6;
			weightings[(int)ShipClassEnum.Alien] = 5;

			weightings = MBIN.SpaceshipWeightings[(int)AlienRaceEnum.None].CivilianClassWeightings;
			weightings[(int)ShipClassEnum.Royal] = 10;
			weightings[(int)ShipClassEnum.Alien] =  1;
		}

		//...........................................................
		
		// 20/21 ships are royal in each system
		protected void ManyRoyal( mbin_gl.GcSolarGenerationGlobals MBIN )
		{		
			// need at least 2 values to be non-0 in order to get large selection of bigger #.
			// e.g. Royal = 100, Alien = 1, all others = 0, gives large selection of Royal in system.		
			foreach( var spaceship in MBIN.SpaceshipWeightings ) {
				var civilian = spaceship.CivilianClassWeightings;
				for( var i = 0; i < civilian.Length; ++i ) civilian[i] = 0;
				civilian[(int)ShipClassEnum.Royal] = 100;
				civilian[(int)ShipClassEnum.Alien] = 1;
			}
		}
	}
}

//=============================================================================
