//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Adjust spacing and density.
	public class Space_Asteroid : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcSolarGenerationGlobals();
		}
		
		//...........................................................
		
		protected void GcSolarGenerationGlobals()
		{
			var mbin = Mbin<mbin_gl.GcSolarGenerationGlobals>(
				"GCSOLARGENERATIONGLOBALS.GLOBAL.MBIN"
			);

			mbin.AsteroidSpacing         = 2000;
			mbin.AsteroidMaxNumGenerates = 3000;

			// [Lo2k]
			
			mbin.AsteroidNoiseRange.x = 0.15f;
			mbin.AsteroidNoiseRange.y = 0.2f;

			mbin.LargeAsteroidNoiseRange.x = 0.18f;
			mbin.LargeAsteroidNoiseRange.y = 0.3f;

			mbin.RareAsteroidNoiseRangeSomeRares.x = 0.24f;
			mbin.RareAsteroidNoiseRangeSomeRares.y = 0.25f;

			mbin.RareAsteroidNoiseRangeLotsOfRares.x = 0.28f;
			mbin.RareAsteroidNoiseRangeLotsOfRares.y = 0.25f;
		}
	}
}

//=============================================================================
