//=============================================================================

using System.Collections.Generic;

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Adjust distances to starting ship and nearest building.
	// Set initial money, make all runes known.
	public class Start : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcBuildingGlobals();
			GcDefaultSaveData();
		}

		//...........................................................

		protected void GcBuildingGlobals()
		{
			var mbin = Mbin<mbin_gl.GcBuildingGlobals>(
				"GCBUILDINGGLOBALS.GLOBAL.MBIN"
			);
			mbin.StartCrashSiteMinDistance = 100;
			mbin.StartCrashSiteMaxDistance = 300;
			mbin.StartShelterMinDistance   = 100;
			mbin.StartShelterMaxDistance   = 500;
		}

		//...........................................................

		protected void GcDefaultSaveData()
		{
			var mbin = Mbin<mbin_gc.GcDefaultSaveData>(
				"METADATA/GAMESTATE/DEFAULTSAVEDATA.MBIN"
			);
			mbin.State.Units    = 10000000;
			mbin.State.Nanites  =   100000;
			mbin.State.Specials =   100000;  // quicksilver

			// start off knowing all portal glyphs, see Portal.
			mbin.State.KnownPortalRunes = 0xffff;  // bitmap

			List_KnownProducts_BuildingPart     (mbin.State.KnownProducts);
			List_KnownProducts_Component        (mbin.State.KnownProducts);
			List_KnownProducts_Consumable       (mbin.State.KnownProducts);
			List_KnownProducts_Curiosity        (mbin.State.KnownProducts);
			List_KnownProducts_CustomisationPart(mbin.State.KnownProducts);
			List_KnownProducts_Tradeable        (mbin.State.KnownProducts);
		}

		//...........................................................
		
		protected void List_KnownProducts_BuildingPart( List<nms.NMSString0x10> LIST )
		{		
			LIST.AddUnique("BASE_FLAG");    // Base Computer
			LIST.AddUnique("BUILDBEACON");  // Save Beacon
			LIST.AddUnique("BUILDSAVE");    // Save Point

			LIST.AddUnique("TELEPORTER");    // Base Teleport Module
			LIST.AddUnique("U_MINIPORTAL");  // Short-Range Teleporter
			LIST.AddUnique("U_PORTALLINE");  // Teleport Cable

			LIST.AddUnique("U_BATTERY_S");     // Battery
			LIST.AddUnique("U_BIOGENERATOR");  // Biofuel Reactor
			LIST.AddUnique("U_SOLAR_S");       // Solar Panel
			LIST.AddUnique("U_GENERATOR_S");   // Electromagnetic Generator
			LIST.AddUnique("U_POWERLINE");     // Electrical Wiring
			
			LIST.AddUnique("U_EXTRACTOR_S");   // Mineral Extractor
			LIST.AddUnique("U_GASEXTRACTOR");  // Gas Extractor
			LIST.AddUnique("U_SILO_S");        // Supply Depot
			LIST.AddUnique("U_PIPELINE");      // Supply Pipe	
			
			LIST.AddUnique("CONTAINER0");  // Storage Container
			LIST.AddUnique("CONTAINER1");  // Storage Container
			LIST.AddUnique("CONTAINER2");  // Storage Container
			LIST.AddUnique("CONTAINER3");  // Storage Container
			LIST.AddUnique("CONTAINER4");  // Storage Container
			LIST.AddUnique("CONTAINER5");  // Storage Container
			LIST.AddUnique("CONTAINER6");  // Storage Container
			LIST.AddUnique("CONTAINER7");  // Storage Container
			LIST.AddUnique("CONTAINER8");  // Storage Container
			LIST.AddUnique("CONTAINER9");  // Storage Container

			LIST.AddUnique("COOKER");  // Nutrient Processor

			LIST.AddUnique("DRESSING_TABLE");  // Appearance Modifier

			LIST.AddUnique("GARAGE_S");       // Nomad Geobay
			LIST.AddUnique("GARAGE_M");       // Roamer Geobay
			LIST.AddUnique("GARAGE_L");       // Colossus Geobay
			LIST.AddUnique("GARAGE_MECH");    // Minotaur Geobay
			LIST.AddUnique("GARAGE_SUB");     // Nautilon Chamber
			LIST.AddUnique("SUMMON_GARAGE");  // Exocraft Summoning Station
		}
		
		//...........................................................
		
		protected void List_KnownProducts_Component( List<nms.NMSString0x10> LIST )
		{
			LIST.AddUnique("AM_HOUSING");   // Antimatter Housing
			LIST.AddUnique("ANTIMATTER");   // Antimatter
			LIST.AddUnique("BIO");          // Amino Chamber
			LIST.AddUnique("CARBON_SEAL");  // Hermetic Seal
			LIST.AddUnique("CASING");       // Metal Plating
			LIST.AddUnique("CATA_CRAFT");   // Sodium Diode
			LIST.AddUnique("CAVE_CRAFT");   // Cobalt Mirror
			LIST.AddUnique("COMPUTER");     // Quantum Computer
			LIST.AddUnique("HYDRALIC");     // Hydraulic Wiring
			LIST.AddUnique("JELLY");        // Di-hydrogen Jelly
			LIST.AddUnique("MAGNET");       // Magnetic Resonator
			LIST.AddUnique("MICROCHIP");    // Microprocessor
			LIST.AddUnique("MIRROR");       // Solar Mirror
			LIST.AddUnique("NANOTUBES");    // Carbon Nanotubes
			LIST.AddUnique("OXY_CRAFT");    // Oxygen Filter
			LIST.AddUnique("WATER_CRAFT");  // Salt Refractor
		}
		
		//...........................................................
		
		protected void List_KnownProducts_Consumable( List<nms.NMSString0x10> LIST )
		{
			LIST.AddUnique("AMMO");  // Projectile Ammunition
			LIST.AddUnique("GRENFUEL1");  // Unstable Plasma

			LIST.AddUnique("BAIT_BASIC");  // Creature Pellets

			LIST.AddUnique("POWERCELL");   // Ion Battery
			LIST.AddUnique("POWERCELL2");  // Advanced Ion Battery
			LIST.AddUnique("SHIPCHARGE");  // Starshield Battery
			LIST.AddUnique("PRODFUEL1");   // Oxygen Capsule
			LIST.AddUnique("PRODFUEL2");   // Life Support Gel
			
			LIST.AddUnique("LAUNCHFUEL");      // Starship Launch Fuel
			LIST.AddUnique("HYPERFUEL1");      // Warp Cell
			LIST.AddUnique("HYPERFUEL2");      // Warp Hypercore			
			LIST.AddUnique("FRIGATE_FUEL_1");  // Frigate Fuel (50 Tonnes)
			LIST.AddUnique("FRIGATE_FUEL_2");  // Frigate Fuel (100 Tonnes)
			LIST.AddUnique("FRIGATE_FUEL_3");  // Frigate Fuel (200 Tonnes)
			LIST.AddUnique("SUBFUEL");         // Hydrothermal Fuel Cell
			
			LIST.AddUnique("TECH_COMP");  // Wiring Loom		
		}
		
		//...........................................................
		
		protected void List_KnownProducts_Curiosity( List<nms.NMSString0x10> LIST )
		{
			LIST.AddUnique("ACCESS1");  // AtlasPass v1
			LIST.AddUnique("ACCESS2");  // AtlasPass v2
			LIST.AddUnique("ACCESS3");  // AtlasPass v3
		}		

		//...........................................................
		
		protected void List_KnownProducts_CustomisationPart( List<nms.NMSString0x10> LIST )
		{
			LIST.AddUnique("FREIGHT_BLACK");
			LIST.AddUnique("FREIGHT_BLUE");
			LIST.AddUnique("FREIGHT_CYAN");
			LIST.AddUnique("FREIGHT_GREEN");
			LIST.AddUnique("FREIGHT_ORANGE");
			LIST.AddUnique("FREIGHT_PINK");
			LIST.AddUnique("FREIGHT_PURPLE");
			LIST.AddUnique("FREIGHT_RED");
			LIST.AddUnique("FREIGHT_WHITE");
			LIST.AddUnique("FREIGHT_YELLOW");

			LIST.AddUnique("JETS_DARK");  // Antimatter Jetpack Trail
			LIST.AddUnique("SHIP_DARK");  // Stealth Starship Trail
		}
		
		//...........................................................
		
		protected void List_KnownProducts_Tradeable( List<nms.NMSString0x10> LIST )
		{
			LIST.AddUnique("FARMPROD1");  // Acid
			LIST.AddUnique("FARMPROD2");  // Lubricant
			LIST.AddUnique("FARMPROD3");  // Glass
		}				
	}
}

//=============================================================================
