//=============================================================================

using System.Collections.Generic;

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Settings|inventory for starting MultiTool when starting a new game.
	public class Start_MultiTool : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcDefaultSaveData();
		}
	
		//...........................................................

		protected void GcDefaultSaveData()
		{
			var mbin = Mbin<mbin_gc.GcDefaultSaveData>(
				"METADATA/GAMESTATE/DEFAULTSAVEDATA.MBIN"
			);
			mbin.State.WeaponLayout.Slots = 12;
			GcInventoryContainer_Main(mbin.State.WeaponInventory);
			List_KnownTech(mbin.State.KnownTech);
		}

		//...........................................................
		
		protected void GcInventoryContainer_Main( mbin_gc.GcInventoryContainer CONTAINER )
		{
			CONTAINER.Slots.Clear();
			CONTAINER.AddTechnologyUnindexed("SCAN1",         100, 100);  // Scanner
			CONTAINER.AddTechnologyUnindexed("SCANBINOC1",     -1, 100);  // Analysis Visor
			CONTAINER.AddTechnologyUnindexed("UT_SURVEY",     100, 100);  // Survey Device
			CONTAINER.AddTechnologyUnindexed("LASER",         100, 100);  // Mining Beam
			CONTAINER.AddTechnologyUnindexed("STRONGLASER",   100, 100);  // Advanced Mining Laser
			CONTAINER.AddTechnologyUnindexed("TERRAINEDITOR", 600, 600);  // Terrain Manipulator
			CONTAINER.AddTechnologyUnindexed("TERRAIN_GREN",   20,  20);  // Geology Cannon
			CONTAINER.AddTechnologyUnindexed("UT_MINER",      100, 100);  // Optical Drill
			CONTAINER.AddTechnologyUnindexed("GROUND_SHIELD", 100, 100);  // Personal Forcefield
		}

		//...........................................................

		protected void List_KnownTech( List<nms.NMSString0x10> LIST )
		{
			LIST.AddUnique("SCAN1");
			LIST.AddUnique("SCANBINOC1");
			LIST.AddUnique("UT_SURVEY");
			LIST.AddUnique("LASER");
			LIST.AddUnique("STRONGLASER");
			LIST.AddUnique("TERRAINEDITOR");
			LIST.AddUnique("TERRAIN_GREN");
			LIST.AddUnique("UT_MINER");
			LIST.AddUnique("GROUND_SHIELD");
		}
	}
}

//=============================================================================
