//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	public class Technology : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcTechnologyTable();
		}

		//...........................................................

		protected void GcTechnologyTable()
		{
			var mbin = Mbin<mbin_gc.GcTechnologyTable>(
				"METADATA/REALITY/TABLES/NMS_REALITY_GCTECHNOLOGYTABLE.MBIN"
			);
			// allow everything, except damaged slots, to be dismantled
			// i.e. SHIPGUN1 - Photon Cannon
			foreach( var tech in mbin.Table ) {
				if( tech.Core && !tech.ID.Value.Contains("DMG") ) tech.Core = false;
			}
		}
	}
}

//=============================================================================
