//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Adjust base radius limits and building item constraints.
	public class Base_Constraints : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcDebugOptions();
			GcBuildingGlobals();
			GcBaseBuildingTable();
		}

		//...........................................................

		protected void GcDebugOptions()
		{
			var mbin = Mbin<mbin_gl.GcDebugOptions>(
				"GCDEBUGOPTIONS.GLOBAL.MBIN"
			);
			mbin.DisableBaseBuildingLimits = true;
		}

		//...........................................................

		protected void GcBuildingGlobals()
		{
			var mbin = Mbin<mbin_gl.GcBuildingGlobals>(
				"GCBUILDINGGLOBALS.GLOBAL.MBIN"
			);

			mbin.MinRadiusForBases       = 1000;
			mbin.MaxRadiusForPlanetBases = 2000;
			mbin.MaxRadiusForSpaceBases  = 2000;
			mbin.BaseRadiusExtension     =  200;

			mbin.BuildingPlacementMaxConnectionLength = 2000;

			mbin.BuildingPlacementScaleMinMax.x = 0.1f;
			mbin.BuildingPlacementScaleMinMax.y = 5;
		}

		//...........................................................

		protected void GcBaseBuildingTable()
		{
			var mbin = Mbin<mbin_gc.GcBaseBuildingTable>(
				"METADATA/REALITY/TABLES/BASEBUILDINGTABLE.MBIN"
			);
			mbin.Objects.ForEach(ITEM => {
				ITEM.RemovesAttachedDecoration = false;
				ITEM.CheckPlaceholderCollision = false;
				ITEM.CanChangeMaterial         = true;
				ITEM.CanChangeColour           = true;
				ITEM.CanPlaceOnItself          = true;
				ITEM.CanRotate3D               = true;
				ITEM.CanScale                  = true;
				// no limit on # can create
				ITEM.FreighterBaseLimit = 0;
				ITEM.PlanetBaseLimit    = 0;
				ITEM.PlanetLimit        = 0;
				ITEM.RegionLimit        = 0;
				// don't dig-out safes if placed outside
				if( string.Compare(ITEM.ID, 0, "CONTAINER", 0, 9) == 0 ) {
					ITEM.EditsTerrain = false;
				}
			});
		}
	}
}

//=============================================================================
