//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	using BaseTerrainEditShapeEnum = mbin_gc.GcBaseBuildingEntry.BaseTerrainEditShapeEnum;

	//=========================================================================

	// Fix terrain edits for some building items.
	public class Base_TerrainEdit : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcBaseBuildingTable();
		}
	
		//...........................................................

		protected void GcBaseBuildingTable()
		{
			var mbin = Mbin<mbin_gc.GcBaseBuildingTable>(
				"METADATA/REALITY/TABLES/BASEBUILDINGTABLE.MBIN"
			);

			// [Lo2k]
			
			var item = mbin.Objects.Find(OBJECT => OBJECT.ID == "BUILDLANDINGPAD");
			item.RemovesAttachedDecoration = false;
			item.TerrainEditBaseYOffset    = 3;
			item.TerrainEditTopYOffset     = 3;
			item.TerrainEditBoundsScalar   = 2;

			item = mbin.Objects.Find(OBJECT => OBJECT.ID == "TELEPORTER");
			item.BaseTerrainEditShape    = BaseTerrainEditShapeEnum.Cylinder;
			item.TerrainEditBaseYOffset  = 0.7f;
			item.TerrainEditTopYOffset   = 0;
			item.TerrainEditBoundsScalar = 1.2f;

			item = mbin.Objects.Find(OBJECT => OBJECT.ID == "RACE_RAMP");
			item.EditsTerrain = true;

			item = mbin.Objects.Find(OBJECT => OBJECT.ID == "RACE_BOOSTER");
			item.EditsTerrain          = true;
			item.TerrainEditTopYOffset = 2;
		}
	}
}

//=============================================================================
