//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Misc. usabilty tweaks.
	public class Global : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcBootLogoData();
			GcDebugOptions();
			GcCameraGlobals();
			GcCharacterGlobals();
			GcGraphicsGlobals();
		}

		//...........................................................

		protected void GcBootLogoData()
		{
			var mbin = Mbin<mbin_gc.GcBootLogoData>(
				"METADATA/UI/BOOTLOGOPC.MBIN"
			);
			for( var i = 0; i < mbin.Textures.Length;    ++i ) mbin.Textures   [i].Value = "";
			for( var i = 0; i < mbin.DisplayTime.Length; ++i ) mbin.DisplayTime[i]       = 0.0f;
		}

		//...........................................................

		protected void GcDebugOptions()
		{
			var mbin = Mbin<mbin_gl.GcDebugOptions>(
				"GCDEBUGOPTIONS.GLOBAL.MBIN"
			);
			
			mbin.SkipIntro = true;
			mbin.SkipLogos = true;
			mbin.BootMusic = false;
		
			mbin.ForceInitialShip   = false;
			mbin.ForceInitialWeapon = false;

			mbin.DisableSaveSlotSorting     = true;
			mbin.UseHeavyAir                = false;
			mbin.SpecialsShop               = true;
			mbin.DisableProfanityFilter     = true;
			mbin.GenerateFarLodBuildingDist = 2000;  // 1000
		}

		//...........................................................

		protected void GcCameraGlobals()
		{
			var mbin = Mbin<mbin_gl.GcCameraGlobals>(
				"GCCAMERAGLOBALS.GLOBAL.MBIN"
			);
			// deactivate all camera shake effects
			foreach( var data in mbin.CameraShakeTable ) {
				data.CapturedData  .Active = false;
				data.MechanicalData.Active = false;
			}
		}

		//...........................................................

		protected void GcCharacterGlobals()
		{
			var mbin = Mbin<mbin_gl.GcCharacterGlobals>(
				"GCCHARACTERGLOBALS.GLOBAL.MBIN"
			);
			// prevent ladder auto-mount, useful w/ ladders in bases
			mbin.LadderDistanceToAutoMount = 0.05f;  // 0.4
		}

		//...........................................................

		protected void GcGraphicsGlobals()
		{
			var mbin = Mbin<mbin_gl.GcGraphicsGlobals>(
				"GCGRAPHICSGLOBALS.GLOBAL.MBIN"
			);
			mbin.LensDirt     = 0;  // 0.3
			mbin.LensDirtCave = 0;  // 0.4
			mbin.TargetTextureMemUsageMB = 5120;  // 1280
		}
	}
}

//=============================================================================
