//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	public class Water : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcWaterGlobals();
			GcWaterColourSettingList();
		}

		//...........................................................

		protected void GcWaterGlobals()
		{
			var mbin = Mbin<mbin_gl.GcWaterGlobals>(
				"GCWATERGLOBALS.GLOBAL.MBIN"
			);

			mbin.WaterDataDay.FoamFadeHeight = 1;  // 21
			mbin.WaterColourNight.FoamColour = new(0.3f, 0.3f, 0.3f, 1);  // white

			// only affects night fog
			mbin.WaterColourNight.WaterFogColourNear = new(0, 0, 0, 0);
			mbin.WaterColourNight.WaterFogColourFar  = new(0, 0, 0, 0);
		}

		//...........................................................		

		protected void GcWaterColourSettingList()
		{
			var mbin = Mbin<mbin_gc.GcWaterColourSettingList>(
				"METADATA/SIMULATION/SOLARSYSTEM/COLOURS/WATERCOLOURS.MBIN"
			);
			foreach( var setting in mbin.Settings ) {
				// only affects day fog
				setting.WaterFogColourNear = new(0, 0, 0, 0);
				setting.WaterFogColourFar  = new(0, 0, 0, 0);
			}
		}
	}
}

//=============================================================================
