//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Adjust mineral|gas extractor rates and silo storage.
	public class Base_Extractor : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcBaseBuildingTable();
		}

		//...........................................................
		
		protected void GcBaseBuildingTable()
		{
			var mbin = Mbin<mbin_gc.GcBaseBuildingTable>(
				"METADATA/REALITY/TABLES/BASEBUILDINGTABLE.MBIN"
			);

			// Mineral Extractors mine faster, hold less (use silos)
			var item = mbin.Objects.Find(OBJECT => OBJECT.ID == "U_EXTRACTOR_S");
			item.LinkGridData.DependsOnHotspots = mbin_gc.GcBaseLinkGridData.DependsOnHotspotsEnum.None;
			item.LinkGridData.Rate    =  200;
			item.LinkGridData.Storage = 1000;

			// Gas Extractors extract faster, hold less (use silos)
			item = mbin.Objects.Find(OBJECT => OBJECT.ID == "U_GASEXTRACTOR");
			item.LinkGridData.DependsOnHotspots = mbin_gc.GcBaseLinkGridData.DependsOnHotspotsEnum.None;
			item.LinkGridData.Rate    =  200;
			item.LinkGridData.Storage = 1000;

			// Silos hold more
			item = mbin.Objects.Find(OBJECT => OBJECT.ID == "U_SILO_S");
			item.LinkGridData.Storage = 3000000;
		}
	}
}

//=============================================================================
