//=============================================================================

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Adjust rates and storage for power related building items.
	public class Base_Power : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcBaseBuildingTable();
		}

		//...........................................................
		
		protected void GcBaseBuildingTable()
		{
			var mbin = Mbin<mbin_gc.GcBaseBuildingTable>(
				"METADATA/REALITY/TABLES/BASEBUILDINGTABLE.MBIN"
			);

			// Batteries hold more and have an ambient trickle-charge ability
			var item = mbin.Objects.Find(OBJECT => OBJECT.ID == "U_BATTERY_S");
			item.LinkGridData.Rate    = 2;
			item.LinkGridData.Storage = 100000;

			// Bio-Generator provides more power, has little storage (use batteries)
			item = mbin.Objects.Find(OBJECT => OBJECT.ID == "U_BIOGENERATOR");
			foreach( var connection in item.LinkGridData.DependentConnections ) {
				connection.DependentRateRate = 600;
			}
			item.LinkGridData.Storage = 100;

			// Solar Panels have more power and some backup storage for brown-outs
			item = mbin.Objects.Find(OBJECT => OBJECT.ID == "U_SOLAR_S");
			item.LinkGridData.Rate    =  100;
			item.LinkGridData.Storage = 1000;

			// EM Generator has A-Class power, can be placed anywhere, has some backup storage
			item = mbin.Objects.Find(OBJECT => OBJECT.ID == "U_GENERATOR_S");
			item.LinkGridData.DependsOnHotspots = mbin_gc.GcBaseLinkGridData.DependsOnHotspotsEnum.None;
			item.LinkGridData.Rate    =  300;
			item.LinkGridData.Storage = 1000;
		}
	}
}

//=============================================================================
