//=============================================================================

using System.Collections.Generic;

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Allow Base Site and Portal scanning from vehicles.
	public class ExoCraft : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcVehicleScanTable();
		}
		
		//...........................................................

		protected void GcVehicleScanTable()
		{
			var mbin = Mbin<mbin_gc.GcVehicleScanTable>(
				"METADATA/SIMULATION/SCANNING/VEHICLESCANTABLE.MBIN"
			);			
			//  Reward_Location required to add base site and portal scan rewards
			if( Reward_Location.SecureBaseSite >= 1 ) GcVehicleScanTable_AddBaseSite(mbin);
			if( Reward_Location.AncientPortal  >= 1 ) GcVehicleScanTable_AddPortal  (mbin);
		}
		
		//...........................................................

		protected void GcVehicleScanTable_AddBaseSite( mbin_gc.GcVehicleScanTable MBIN )
		{
			var entry         = MBIN.VehicleScanTable.Find(ENTRY => ENTRY.ScanList[0] == "ABANDONED");
			var basesite      = entry.Clone();
			basesite.ScanList = new(){ "BASE" };
			MBIN.VehicleScanTable.Add(basesite);
		}

		//...........................................................

		protected void GcVehicleScanTable_AddPortal( mbin_gc.GcVehicleScanTable MBIN )
		{
			var entry       = MBIN.VehicleScanTable.Find(ENTRY => ENTRY.ScanList[0] == "MONOLITH");
			var portal      = entry.Clone();
			portal.ScanList = new(){ "PORTAL" };
			MBIN.VehicleScanTable.Add(portal);
		}		
	}
}

//=============================================================================
