//=============================================================================

using System.Collections.Generic;

using nms     = libMBIN.NMS;
using mbin_gl = libMBIN.NMS.Globals;
using mbin_gc = libMBIN.NMS.GameComponents;
using mbin_tk = libMBIN.NMS.Toolkit;

//=============================================================================

namespace cmk.NMS.Scripts.Mod
{
	// Settings|inventory for ExoSuit when starting a new game.
	public class Start_ExoSuit : cmk.NMS.ModScript
	{
		protected override void Execute()
		{
			GcRealityManagerData();
			GcDefaultSaveData();
		}

		//...........................................................
		
		public static int MaxAmount   { get; set; } = Inventory.MaxAmount;
		public static int StartAmount { get; set; } = MaxAmount / 2;	
		
		//...........................................................

		protected void GcRealityManagerData()
		{
			var mbin = Mbin<mbin_gc.GcRealityManagerData>(
				"METADATA/REALITY/DEFAULTREALITY.MBIN"
			);
			mbin.SuitTechOnlyStartingSlotLayout.Slots = 16;
			mbin.SuitStartingSlotLayout        .Slots = 32;
			mbin.SuitCargoStartingSlotLayout   .Slots = 64;
		}

		//...........................................................

		protected void GcDefaultSaveData()
		{
			var mbin = Mbin<mbin_gc.GcDefaultSaveData>(
				"METADATA/GAMESTATE/DEFAULTSAVEDATA.MBIN"
			);
			GcPlayerStateData (mbin.State);
			List_KnownTech    (mbin.State.KnownTech);
			List_KnownProducts(mbin.State.KnownProducts);
		}

		//...........................................................

		protected void GcPlayerStateData( mbin_gc.GcPlayerStateData DATA )
		{			
			// if you add more items to an inventory than its StartingSlotLayout the extra items are ignored.
			// if you stack more in a slot than allowed the amount is truncated to the max allowable.		
			GcInventoryContainer_Tech (DATA.Inventory_TechOnly);
			GcInventoryContainer_Main (DATA.Inventory);
			GcInventoryContainer_Cargo(DATA.Inventory_Cargo);		
		}

		//...........................................................
		
		protected void GcInventoryContainer_Tech( mbin_gc.GcInventoryContainer CONTAINER )
		{	
			CONTAINER.Slots.Clear();
			CONTAINER.AddTechnologyUnindexed("SUIT_REFINER",   100, 100);  // Personal Refiner
			CONTAINER.AddTechnologyUnindexed("ENERGY",         100, 100);  // Life Support
			CONTAINER.AddTechnologyUnindexed("PROTECT",        100, 100);  // Hazard Protection
			CONTAINER.AddTechnologyUnindexed("POWERGLOVE",     100, 100);  // Haz-Mat Gauntlet
			CONTAINER.AddTechnologyUnindexed("UT_WATER",       100, 100);  // Aeration Membrane
			CONTAINER.AddTechnologyUnindexed("UT_WATERENERGY", 100, 100);  // Oxygen Rerouter
			CONTAINER.AddTechnologyUnindexed("JET1",           100, 100);  // Jetpack
			CONTAINER.AddTechnologyUnindexed("UT_MIDAIR",      100, 100);  // Airburst Engine
			CONTAINER.AddTechnologyUnindexed("UT_WATERJET",    100, 100);  // Efficient Water Jets
		}

		//...........................................................
		
		protected void GcInventoryContainer_Main( mbin_gc.GcInventoryContainer CONTAINER )
		{			
			CONTAINER.Slots.Clear();
			CONTAINER.AddProductUnindexed("ACCESS3", 1, MaxAmount);  // AtlasPass v3

			CONTAINER.AddProductUnindexed("NAV_DATA",       9000, MaxAmount);  // Navigation Data
			CONTAINER.AddProductUnindexed("SHIP_INV_TOKEN", 9000, MaxAmount);  // Storage Augmentation
			CONTAINER.AddProductUnindexed("WEAP_INV_TOKEN", 9000, MaxAmount);  // Multi-Tool Expansion Slot

			CONTAINER.AddProductUnindexed("ABAND_LOCATOR", 100, MaxAmount);  // Emergency Broadcast Receiver
			CONTAINER.AddProductUnindexed("POI_LOCATOR",   100, MaxAmount);  // Anomaly Detector
			
			CONTAINER.AddProductUnindexed("BAIT_BASIC", StartAmount, MaxAmount);  // Creature Pellets
			CONTAINER.AddProductUnindexed("AMMO",       StartAmount, MaxAmount);  // Projectile Ammunition

			CONTAINER.AddProductUnindexed("EXP_CURIO1", 100, MaxAmount);  // Korvax Casing
			CONTAINER.AddProductUnindexed("WAR_CURIO2", 100, MaxAmount);  // Vy'keen Dagger
			CONTAINER.AddProductUnindexed("TRA_CURIO1", 100, MaxAmount);  // Gek Relic		
			
			CONTAINER.AddProductUnindexed("BP_SALVAGE",    1000, MaxAmount);  // Salvaged Data
			CONTAINER.AddProductUnindexed("FACT_TOKEN",     100, MaxAmount);  // Factory Override Unit		
			CONTAINER.AddProductUnindexed("SUIT_INV_TOKEN", 100, MaxAmount);  // Exosuit Expansion Unit
		//	CONTAINER.AddProductUnindexed("NAV_DATA_DROP",  100, MaxAmount);  // Drop Pod Coordinate Data			
		}
		
		//...........................................................
		
		protected void GcInventoryContainer_Cargo( mbin_gc.GcInventoryContainer CONTAINER )
		{								
			CONTAINER.Slots.Clear();
			CONTAINER.AddSubstanceUnindexed("LAUNCHSUB",  StartAmount, MaxAmount);  // Di-hydrogen
			CONTAINER.AddSubstanceUnindexed("LAUNCHSUB2", StartAmount, MaxAmount);  // Deuterium
			CONTAINER.AddSubstanceUnindexed("ROCKETSUB",  StartAmount, MaxAmount);  // Tritium

			CONTAINER.AddSubstanceUnindexed("OXYGEN", StartAmount, MaxAmount);  // Oxygen
			CONTAINER.AddSubstanceUnindexed("COLD1",  StartAmount, MaxAmount);  // Dioxite

			CONTAINER.AddSubstanceUnindexed("FUEL1", StartAmount, MaxAmount);  // Carbon
			CONTAINER.AddSubstanceUnindexed("FUEL2", StartAmount, MaxAmount);  // Condensed Carbon

			CONTAINER.AddSubstanceUnindexed("CATALYST1", StartAmount, MaxAmount);  // Sodium	
			CONTAINER.AddSubstanceUnindexed("CATALYST2", StartAmount, MaxAmount);  // Sodium Nitrate

			CONTAINER.AddSubstanceUnindexed("LAND1", StartAmount, MaxAmount);  // Ferrite Dust
			CONTAINER.AddSubstanceUnindexed("LAND2", StartAmount, MaxAmount);  // Pure Ferrite
			CONTAINER.AddSubstanceUnindexed("LAND3", StartAmount, MaxAmount);  // Magnetised Ferrite
			CONTAINER.AddSubstanceUnindexed("SAND1", StartAmount, MaxAmount);  // Silicate Powder

			CONTAINER.AddSubstanceUnindexed("YELLOW2",   StartAmount, MaxAmount);  // Copper
			CONTAINER.AddSubstanceUnindexed("EX_YELLOW", StartAmount, MaxAmount);  // Activated Copper
			CONTAINER.AddSubstanceUnindexed("STELLAR2",  StartAmount, MaxAmount);  // Chromatic Metal
	
			CONTAINER.AddSubstanceUnindexed("CAVE1", StartAmount, MaxAmount);  // Cobalt
			CONTAINER.AddSubstanceUnindexed("CAVE2", StartAmount, MaxAmount);  // Ionised Cobalt

			CONTAINER.AddSubstanceUnindexed("ASTEROID1", StartAmount, MaxAmount);  // Silver
			CONTAINER.AddSubstanceUnindexed("ASTEROID3", StartAmount, MaxAmount);  // Platinum
			CONTAINER.AddSubstanceUnindexed("ASTEROID2", StartAmount, MaxAmount);  // Gold
			CONTAINER.AddSubstanceUnindexed("RADIO1",    StartAmount, MaxAmount);  // Uranium		
			CONTAINER.AddSubstanceUnindexed("DUSTY1",    StartAmount, MaxAmount);  // Pyrite

			CONTAINER.AddSubstanceUnindexed("CREATURE1", StartAmount, MaxAmount);  // Mordite
			CONTAINER.AddSubstanceUnindexed("ROBOT1",    StartAmount, MaxAmount);  // Pugneum
			
			CONTAINER.AddSubstanceUnindexed("HOT1",  StartAmount, MaxAmount);  // Phosphorus
			CONTAINER.AddSubstanceUnindexed("LUSH1", StartAmount, MaxAmount);  // Paraffinium

			CONTAINER.AddSubstanceUnindexed("WATER1", StartAmount, MaxAmount);  // Salt
			CONTAINER.AddSubstanceUnindexed("WATER2", StartAmount, MaxAmount);  // Chlorine
			CONTAINER.AddSubstanceUnindexed("TOXIC1", StartAmount, MaxAmount);  // Ammonia

			CONTAINER.AddSubstanceUnindexed("RED2",   StartAmount, MaxAmount);  // Cadmium
			CONTAINER.AddSubstanceUnindexed("GREEN2", StartAmount, MaxAmount);  // Emeril
			CONTAINER.AddSubstanceUnindexed("BLUE2",  StartAmount, MaxAmount);  // Indium

			CONTAINER.AddProductUnindexed("TECH_COMP", StartAmount, MaxAmount);  // Wiring Loom
			CONTAINER.AddProductUnindexed("MICROCHIP", StartAmount, MaxAmount);  // Microprocessor

			CONTAINER.AddProductUnindexed("GEODE_SPACE",   StartAmount, MaxAmount);  // Tritium Hypercluster
			CONTAINER.AddProductUnindexed("STORM_CRYSTAL", StartAmount, MaxAmount);  // Storm Crystal

			CONTAINER.AddProductUnindexed("FARMPROD3", StartAmount, MaxAmount);  // Glass
			CONTAINER.AddProductUnindexed("CLAMPEARL", StartAmount, MaxAmount);  // Living Pearl
			CONTAINER.AddProductUnindexed("VENTGEM",   StartAmount, MaxAmount);  // Crystal Sulphide

			CONTAINER.AddProductUnindexed("ANTIMATTER", StartAmount, MaxAmount);  // Antimatter
			CONTAINER.AddProductUnindexed("HYPERFUEL1", StartAmount, MaxAmount);  // Warp Cell

			CONTAINER.AddProductUnindexed("JELLY",       StartAmount, MaxAmount);  // Di-hydrogen Jelly
			CONTAINER.AddProductUnindexed("NANOTUBES",   StartAmount, MaxAmount);  // Carbon Nanotubes
			CONTAINER.AddProductUnindexed("CASING",      StartAmount, MaxAmount);  // Metal Plating
			CONTAINER.AddProductUnindexed("CARBON_SEAL", StartAmount, MaxAmount);  // Hermetic Seal
		}
		
		//...........................................................

		protected void List_KnownTech( List<nms.NMSString0x10> LIST )
		{
			LIST.AddUnique("SUIT_REFINER");
			LIST.AddUnique("ENERGY");
			LIST.AddUnique("PROTECT");
			LIST.AddUnique("POWERGLOVE");
			LIST.AddUnique("UT_WATER");
			LIST.AddUnique("UT_WATERENERGY");
			LIST.AddUnique("JET1");
			LIST.AddUnique("UT_MIDAIR");
			LIST.AddUnique("UT_WATERJET");
		}

		//...........................................................

		protected void List_KnownProducts( List<nms.NMSString0x10> LIST )
		{
			LIST.AddUnique("JELLY");
			LIST.AddUnique("NANOTUBES");
			LIST.AddUnique("CASING");
			LIST.AddUnique("CARBON_SEAL");
			LIST.AddUnique("TECH_COMP");
			LIST.AddUnique("MICROCHIP");
			LIST.AddUnique("ANTIMATTER");
			LIST.AddUnique("HYPERFUEL1");
			LIST.AddUnique("ACCESS3");
			LIST.AddUnique("BP_SALVAGE");
			LIST.AddUnique("NAV_DATA");
			LIST.AddUnique("FACT_TOKEN");
			LIST.AddUnique("SHIP_INV_TOKEN");
			LIST.AddUnique("WEAP_INV_TOKEN");
			LIST.AddUnique("SUIT_INV_TOKEN");
			LIST.AddUnique("NAV_DATA_DROP");
			LIST.AddUnique("GEODE_SPACE");
			LIST.AddUnique("STORM_CRYSTAL");
			LIST.AddUnique("EXP_CURIO1");
			LIST.AddUnique("WAR_CURIO2");
			LIST.AddUnique("TRA_CURIO1");
			LIST.AddUnique("FARMPROD3");
			LIST.AddUnique("CLAMPEARL");
			LIST.AddUnique("VENTGEM");
			LIST.AddUnique("BAIT_BASIC");
			LIST.AddUnique("WALKER_PROD");
			LIST.AddUnique("ABAND_LOCATOR");
			LIST.AddUnique("POI_LOCATOR");
		}		
	}
}

//=============================================================================
